% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_vector.R
\name{style_vector}
\alias{style_vector}
\title{Style a Vector with Text Formatting}
\usage{
style_vector(
  x,
  output = "html",
  bold = FALSE,
  italic = FALSE,
  monospace = FALSE,
  smallcap = FALSE,
  underline = FALSE,
  strikeout = FALSE,
  color = NULL,
  fontsize = NULL,
  indent = NULL
)
}
\arguments{
\item{x}{A vector to be styled.}

\item{output}{Output format for styling. One of "html", "latex", "typst", "markdown", "ansi". Defaults to "html".}

\item{bold}{Logical; if \code{TRUE}, text is styled in bold. Must be of length 1 or \code{length(x)}.}

\item{italic}{Logical; if \code{TRUE}, text is styled in italic. Must be of length 1 or \code{length(x)}.}

\item{monospace}{Logical; if \code{TRUE}, text is styled in monospace font. Must be of length 1 or \code{length(x)}.}

\item{smallcap}{Logical; if \code{TRUE}, text is styled in small caps. In Markdown output format, text is converted to uppercase. Must be of length 1 or \code{length(x)}.}

\item{underline}{Logical; if \code{TRUE}, text is underlined. Must be of length 1 or \code{length(x)}.}

\item{strikeout}{Logical; if \code{TRUE}, text has a strike through line. Must be of length 1 or \code{length(x)}.}

\item{color}{Text color. Must be of length 1 or \code{length(x)}. There are several ways to specify colors:
\itemize{
\item HTML:
\itemize{
\item Hex code composed of # and 6 characters, ex: #CC79A7.
\item Keywords: black, silver, gray, white, maroon, red, purple, fuchsia, green, lime, olive, yellow, navy, blue, teal, aqua
}
\item LaTeX:
\itemize{
\item Hex code composed of # and 6 characters, ex: "#CC79A7".
\item Keywords: black, blue, brown, cyan, darkgray, gray, green, lightgray, lime, magenta, olive, orange, pink, purple, red, teal, violet, white, yellow.
\item Color blending using xcolor, ex: \verb{white!80!blue}, \verb{green!20!red}.
\item Color names with luminance levels from the \code{ninecolors} package.
}
}}

\item{fontsize}{Font size in em units. Must be of length 1 or \code{length(x)}. Can be \code{NULL} for default size.}

\item{indent}{Text indentation in em units. Must be of length 1 or \code{length(x)}. Positive values only.}
}
\value{
A character vector with applied styling.
}
\description{
Style a Vector with Text Formatting
}
\details{
This function applies styling to a vector. It allows customization of text style (bold, italic, monospace), text color, font size, and text decorations (underline, strikeout). The styling is applied element-wise to the vector. Vectors are coerced with \code{as.character()} before styling.
}
\examples{
# Basic styling
style_vector(c("Hello", "World"), bold = TRUE, color = "red")

# Different styles per element
style_vector(
  c("Bold text", "Italic text", "Monospace"),
  bold = c(TRUE, FALSE, FALSE),
  italic = c(FALSE, TRUE, FALSE),
  monospace = c(FALSE, FALSE, TRUE)
)

# Single style applied to all elements
style_vector(c("A", "B", "C"), color = "blue", fontsize = 1.2)
}
