% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_reliability}
\alias{plot.tna_reliability}
\title{Plot Reliability Analysis Results}
\usage{
\method{plot}{tna_reliability}(x, type = "histogram", metric = "Median Abs. Diff.", ...)
}
\arguments{
\item{x}{A \code{tna_reliability} object.}

\item{type}{A \code{character} string specifying the plot type. The options are:
\code{"histogram"} (default), \code{"density"}, or \code{"boxplot"}.}

\item{metric}{A \code{character} string specifying the metric to plot.
The default is the median absolute difference (\code{"Median Abs. Diff."}).}

\item{...}{Ignored}
}
\description{
Plot Reliability Analysis Results
}
\examples{
# Small number of iterations for CRAN
model <- tna(engagement)
rel <- reliability(model, iter = 20)
plot(rel)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
