################################################################################
# Returns a vector of warning marks in superscript, and related warning notes
# if the value of an equivalence threshold is too small to ever reject Ho given
# the alpha and the critical value of a test statistic.
# Author: Alexis Dinno
# Date: Dec 12, 2025
# Takes: Five floats
impossibledelta <- function(lower, upper, se, df, alpha) {
  # In future this is where to calculate the critical value depending on if test stat is T or Z (bootstrap)
  criticalvalue <- se*qt(1-alpha, df)
  test_crit     <- "t-crit"
  # Returns are based on symmetric & assymetric equivalence thresholds
  impossible_mark  <- ""
  impossible_markl <- ""
  impossible_marku <- ""
  impossible_note  <- ""
  impossible_notel <- ""
  impossible_noteu <- ""
  if (upper == lower & lower <= criticalvalue) {
    impossible_mark <- "\U1D43"
    impossible_note <- paste0(
        impossible_mark,
        " Impossible to reject any Ho if \U0394 \U2264 ", 
        test_crit, 
        "\U00D7s.e., or if \U03B5 \U2264 ", 
        test_crit, 
        ". See help(tost.regress).")
    }
  if (upper != lower & lower <= criticalvalue) {
    impossible_markl <- "\U1D38"
    impossible_notel <- paste0(
        impossible_markl, 
        " Impossible to reject any Ho if |\U0394\U006C| \U2264 ", 
        test_crit, "\U00D7s.e., or if |\U03B5\U006C| \U2264 ", 
        test_crit, 
        ". See help(tost.regress).")
    }
  if (upper != lower & upper <= criticalvalue) {
    impossible_marku <- "\U1D41"
    impossible_noteu <- paste0(
        impossible_marku, 
        " Impossible to reject any Ho if \U0394\U0075 \U2264 ", 
        test_crit, 
        "\U00D7s.e., or if \U03B5\U0075 \U2264 ", 
        test_crit, 
        ". See help(tost.regress).")
    }
  return(c(impossible_mark, impossible_note, impossible_markl, impossible_notel, impossible_marku, impossible_noteu))
  }