% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transGFM.R
\name{source_potential}
\alias{source_potential}
\title{Identify potential sources based on rank comparison using IC criterion}
\usage{
source_potential(
  X_sources,
  X0,
  r_max = 10,
  ic_type = "IC1",
  data_type = "count",
  C = NULL,
  max_iter = 30,
  verbose = TRUE
)
}
\arguments{
\item{X_sources}{List of source data matrices (may contain missing values)}

\item{X0}{Target data matrix (may contain missing values)}

\item{r_max}{Maximum number of factors to consider (default: 10)}

\item{ic_type}{IC criterion type: "IC1" or "IC2" (default: "IC1")}

\item{data_type}{Type of data: "continuous", "count", or "binary"}

\item{C}{CJMLE projection constant (if NULL, auto-calculated)}

\item{max_iter}{Maximum CJMLE iterations (default: 30)}

\item{verbose}{Print progress information (default: TRUE)}
}
\value{
List with positive_potential_sources, negative_sources, r_target, r_sources
}
\description{
Identify potential sources based on rank comparison using IC criterion
}
\examples{
\donttest{
# Generate Poisson data
set.seed(2025)

# Generate 5 sources with different ranks
n1 <- 100; p1 <- 100
source_list <- list()

# Sources 1-2: rank 2 (same as target)
r_s <- 2
F_s <- matrix(runif(n1 * r_s, min = -2, max = 2), n1, r_s)
B_s <- matrix(runif(p1 * r_s, min = -2, max = 2), p1, r_s)
M_s <- F_s \%*\% t(B_s)
for (s in 1:2) {
  X_s <- matrix(rpois(n1 * p1, exp(M_s)), n1, p1)

  # Add 10\% missing values
  n_missing <- floor(n1 * p1 * 0.1)
  missing_idx <- sample(n1 * p1, n_missing)
  X_s[missing_idx] <- NA

  source_list[[s]] <- X_s
}

# Sources 3-5: rank 3 (different from target)
for (s in 3:5) {
  r_s_nega <- 3
  F_s_nega <- matrix(runif(n1 * r_s_nega, min = -2, max = 2), n1, r_s_nega)
  B_s_nega <- matrix(runif(p1 * r_s_nega, min = -2, max = 2), p1, r_s_nega)
  M_s_nega <- F_s_nega \%*\% t(B_s_nega)
  X_s_nega <- matrix(rpois(n1 * p1, exp(M_s_nega)), n1, p1)

  n_missing <- floor(n1 * p1 * 0.1)
  missing_idx <- sample(n1 * p1, n_missing)
  X_s_nega[missing_idx] <- NA

  source_list[[s]] <- X_s_nega
}

# Target data: rank 2
n0 <- 50; p0 <- 50; r_target <- 2
M_target <- M_s[1:n0, 1:p0]
X_target <- matrix(rpois(n0 * p0, exp(M_target)), n0, p0)

# Identify potential sources
result <- source_potential(
  X_sources = source_list,
  X0 = X_target,
  r_max = 5,
  ic_type = "IC1",
  data_type = "count",
  verbose = TRUE
)

print(result$positive_potential_sources)  # Should be c(1, 2)
print(result$negative_sources)            # Should be c(3, 4, 5)
print(result$r_target)                    # Should be 2
print(result$r_sources)                   # Should be c(2, 2, 3, 3, 3)
}
}
