% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{gecm.dummy.checks}
\alias{gecm.dummy.checks}
\title{Do consistent dummy checks for functions (GDTE/GDRF) that use a GECM model}
\usage{
gecm.dummy.checks(
  x.vrbl,
  y.vrbl,
  x.d.vrbl,
  y.d.vrbl,
  x.vrbl.d.x,
  y.vrbl.d.y,
  x.d.vrbl.d.x,
  y.d.vrbl.d.y,
  inferences.x,
  inferences.y,
  the.coef,
  se.type,
  type = NULL
)
}
\arguments{
\item{x.vrbl}{a named vector of the x variables and corresponding lag orders of lower order of integration (typically levels, 0) in a GECM model}

\item{y.vrbl}{a named vector of the y variables and corresponding lag orders of lower order of integration (typically levels, 0) in a GECM model}

\item{x.d.vrbl}{a named vector of the x variables and corresponding lag orders of higher order of integration (typically first differences, 1) in a GECM model}

\item{y.d.vrbl}{a named vector of the y variables and corresponding lag orders of higher order of integration (typically first differences, 1) in a GECM model}

\item{x.vrbl.d.x}{the order of differencing of the x variable of lower order of integration (typically levels, 0) in a GECM model}

\item{y.vrbl.d.y}{the order of differencing of the y variable of lower order of integration (typically levels, 0) in a GECM model}

\item{x.d.vrbl.d.x}{the order of differencing of the x variable of higher order of integration (typically first differences, 1) in a GECM model}

\item{y.d.vrbl.d.y}{the order of differencing of the y variable of higher order of integration (typically first differences, 1) in a GECM model}

\item{inferences.x}{is the independent variable treated in levels or in differences?}

\item{inferences.y}{are the inferences for the dependent variable expected in levels or in differences?}

\item{the.coef}{the coefficient vector from the estimated GECM model}

\item{se.type}{the type of standard error calculated}

\item{type}{whether the effects are estimated in the context of a GDTE/GDRF}
}
\description{
Do consistent dummy checks for functions (GDTE/GDRF) that use a GECM model
}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshi Rajan
}
\keyword{internal}
