% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.0.R
\name{tsarima}
\alias{tsarima}
\alias{print.tsarima}
\alias{summary.tsarima}
\title{Fitting ARIMA Models}
\usage{
tsarima(
  x,
  order = c(0L, 0L, 0L),
  seasonal = list(order = c(0L, 0L, 0L), period = NA),
  xreg = NULL,
  include.const = TRUE,
  log = FALSE,
  train.prop = 1,
  arch.test = FALSE,
  transform.pars = TRUE,
  fixed = NULL,
  init = NULL,
  method = c("CSS-ML", "ML", "CSS"),
  SSinit = c("Gardner1980", "Rossignol2011"),
  optim.method = "BFGS",
  optim.control = list(),
  kappa = 1e+06
)

\method{print}{tsarima}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  se = TRUE,
  signif.stars = TRUE,
  ...
)

\method{summary}{tsarima}(
  object,
  digits = max(3L, getOption("digits") - 3L),
  se = TRUE,
  signif.stars = TRUE,
  ...
)
}
\arguments{
\item{x}{a univariate time series or an `\code{tsarima}` object.}

\item{order}{a specification of the non-seasonal part of the ARIMA model: the three integer components \eqn{(p, d, q)} are the AR order, the degree of differencing, and the MA order.}

\item{seasonal}{a specification of the seasonal part of the ARIMA model \eqn{(P, D, Q)}, the seasonal AR order, the degree of seasonal differencing, and the seasonal MA order, plus the period (which defaults to \code{frequency(x)}). This should be a list with components \code{order} and \code{period}, but a specification of just a numeric vector of length 3 will be turned into a suitable list with the specification as the order.}

\item{xreg}{optional. A vector or matrix of external regressors, which must have the same number of rows as \code{x}.}

\item{include.const}{logical. Indicates if the ARMA model should include a mean/intercept term. The default is \code{TRUE} for non-differenced series. For ARIMA models with differencing, it may fail to estimate the standard errors.}

\item{log}{optional. A logical value indicating whether the forecasted values are log-transformed and should be inverted back to the original series scale. If the object is an \code{tsarima} model and this parameter is omitted, the value will be taken over by the settings of the model given in object. Default is \code{NULL} here.}

\item{train.prop}{a numerical value specifying the proportion of training data in the series. The value must be between 0 and 1. Default is \code{1}.}

\item{arch.test}{optional. A logical value indicating whether the ARCH effect in the residuals should be tested by the McLeod-Li test of not. Default is \code{FALSE}.}

\item{transform.pars}{logical. If \code{TRUE}, the AR parameters are transformed to ensure that they remain in the region of stationarity. Not used for \code{method = "CSS"}. For \code{method = "ML"}, it has been advantageous to set \code{transform.pars = FALSE} in some cases, see also \code{fixed}.}

\item{fixed}{optional. Numeric vector of the same length as the total number of coefficients to be estimated. It should be of the form 
\deqn{(\phi_1,\ldots,\phi_p,\theta_1,\ldots,\theta_q,\Phi_1,\ldots,\Phi_P,\Theta_1,\ldots,\Theta_Q,\mu)} 
where \eqn{\phi_i} are the AR coefficients, \eqn{\theta_i} are the MA coefficients, \eqn{\Phi_i} are the seasonal AR coefficients, \eqn{\Theta_i} are the seasonal MA coefficients and \eqn{\mu} is the intercept term. 
\cr Note that the \eqn{\mu} entry is required if and only if \code{include.const} is \code{TRUE}. In particular it should not be present if the model is an ARIMA model with differencing.
\cr The entries of the \code{fixed} vector should consist of the values at which the user wishes to `fix` the corresponding coefficient, or \code{NA} if that coefficient should \emph{not} be fixed, but estimated.
\cr The argument \code{transform.pars} will be set to \code{FALSE} if any AR parameters are fixed. A warning will be given if \code{transform.pars} is set to (or left at its default) \code{TRUE}. It may be wise to set \code{transform.pars = FALSE} even when fixing MA parameters, especially at values that cause the model to be nearly non-invertible.}

\item{init}{optional. Numeric vector of initial parameter values. Missing values will be filled in, by zeroes except for regression coefficients. Values already specified in \code{fixed} will be ignored.}

\item{method}{fitting method. Maximum likelihood or minimize conditional sum-of-squares. The default (unless there are missing values) is to use conditional-sum-of-squares to find starting values, then maximum likelihood. Can be abbreviated.}

\item{SSinit}{a string specifying the algorithm to compute the state-space initialization of the likelihood; see \code{\link{KalmanLike}} for details. Can be abbreviated.}

\item{optim.method}{The value passed as the method argument to \code{\link{optim}}.}

\item{optim.control}{List of control parameters for \code{\link{optim}}.}

\item{kappa}{the prior variance (as a multiple of the innovations variance) for the past observations in a differenced model. Do not reduce this.}

\item{digits}{the number of significant digits.}

\item{se}{logical. If \code{TRUE}, standard error will be included in displaying the result. Default is \code{TRUE}.}

\item{signif.stars}{logical. If \code{TRUE}, a shorthand used to indicate the statistical significance of a result will be displayed next to the p-values with *** for p < 0.001, ** for p < 0.01, * for p < 0.05, and . for p < 0.1. Default is \code{TRUE}.}

\item{...}{other printing or summary parameters.}

\item{object}{a \code{tsarima} object for summary.}
}
\value{
A list of class `\code{tsarima}` with components:

\item{coef}{a vector of AR, MA and regression coefficients, which can be extracted by the \code{\link{coef}} method.}

\item{const}{a value of the model's constant term. Return \code{NULL} if \code{include.const = FALSE}.}

\item{sigma2}{the maximum likelihood estimate of the white noise variance.}

\item{var.coef}{he estimated variance matrix of the coefficients \code{coef}, which can be extracted by the \code{vcov} method.}

\item{loglik}{the maximized log-likelihood (of the differenced data), or the approximation to it used.}

\item{aic, aicc, bic}{the AIC, AICc, and BIC values corresponding to the log-likelihood. Only valid for method = `ML` fits.}

\item{error}{a list of prediction error estimators, including \code{$ME} for mean error, \code{$RMSE} for root mean squared error, \code{$MAE} for mean absolute error, \code{$MPE} for mean percentage error, \code{$MAPE} for mean absolute percentage error, \code{$MASE} for mean absolute scaled error, \code{$MASE.S} for seasonal mean absolute scaled error, and \code{$ACF1} for lag 1 autocorrelation.}

\item{arma}{a vector of the ARIMA order: \eqn{(p, P, q, Q, \ell, d, D)}.}

\item{train.prop}{proportion of training data.}

\item{x}{data of the original series.}

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{x.time.used}{list of time in which the series values were used for model fitting. It will be the same as \code{x.time} if \code{train.prop = 1}.}

\item{x.used}{data of the original series which were used for model fitting. It will be the same as \code{x} if \code{train.prop = 1}.}

\item{fitted}{a vector of fitted series values. If \code{train.prop} is smaller than 1, it will have the same length as \code{x.used}.}

\item{residuals}{a vector of the series residuals. If \code{train.prop} is smaller than 1, it will have the same length as \code{x.used}.}

\item{exp.fitted}{a vector of fitted series values after inverted from log-transformation. Only available if \code{log = TRUE}. If \code{train.prop} is smaller than 1, it will have the same length as \code{x.used}.}

\item{exp.residuals}{a vector of the series residuals after inverted from log-transformation. Only available if \code{log = TRUE}. If \code{train.prop} is smaller than 1, it will have the same length as \code{x.used}.}

\item{log}{logical. Indicates whether series values are log-transformed for model fitting or not.}

\item{call}{the matched call.}

\item{series}{series name \code{x} in match call.}

\item{code}{the convergence value returned by \code{\link{optim}}.}

\item{nobs}{the number of `used` observations for the fitting, can also be extracted via \code{\link{nobs}} and is used by \code{\link{BIC}}.}

\item{model}{a list representing the Kalman filter used in the fitting. See \code{\link{KalmanLike}}.}

\item{mcleod.li.test}{resulting chi-square test statistics and the corresponding p-values of the McLeod-Li test for ARCH effect. Only available if \code{arch.test = TRUE}.}

\item{model.test}{a list of information regarding the prediction of the testing data including `\code{x.test}` (part of `\code{x}` used for testing), `\code{fitted.test}` (predicted values of the testing data), `\code{residuals.test}` (prediction error of the testing data), and `\code{error.test}` (prediction error measurements based on the testing data). Only available if \code{train.prop} is smaller than 1.}
}
\description{
The `\code{tsarima}` function is used to fit an ARIMA model to a univariate time series.
}
\details{
Different definitions of ARMA models have different signs for the AR and/or MA coefficients. The definition used here is the original Box & Jenkins (1970) formulation:

\eqn{x_t=\phi_1 x_{t-1}+\ldots+\phi_p x_{t-p}+\varepsilon_t-\theta_1\varepsilon_{t-1}-\ldots-\theta_p\varepsilon_{t-q}}

and so the MA coefficients differ in sign from the output of \code{stats::arima}. Further, if \code{include.const} is \code{TRUE} (the default for an ARMA model), this formula applies to \eqn{x_t-\mu} rather than \eqn{x_t}. For ARIMA models with differencing, the differenced series usually follows a zero-mean ARMA model, but \code{include.const} is still available in case a constant term is required for the model. However, the estimation of the coefficients' standard error may not be successful. If an \code{xreg} term is included, a linear regression (with a constant term if \code{include.mean} is \code{TRUE} and there is no differencing) is fitted with an ARMA model for the error term.

The variance matrix of the estimates is found from the Hessian of the log-likelihood, and so may only be a rough guide.

Optimization is done by \code{\link{optim}}. It will work best if the columns in \code{xreg} are roughly scaled to zero mean and unit variance, but does attempt to estimate suitable scalings.

If \code{train.prop} is smaller than 1, the function will only treat the training part of the series as past data. When applying `\code{tsforecast}` or `\code{predict}`, the forecast will start after the end of the training part of the original series.
}
\section{Fitting methods}{
 
The exact likelihood is computed via a state-space representation of the ARIMA process, and the innovations and their variance found by a Kalman filter. The initialization of the differenced ARMA process uses stationarity and is based on Gardner et. al. (1980). For a differenced process the non-stationary components are given a diffuse prior (controlled by \code{kappa}). Observations which are still controlled by the diffuse prior (determined by having a Kalman gain of at least \code{1e4}) are excluded from the likelihood calculations. (This gives comparable results to \code{\link{arima0}} in the absence of missing values, when the observations excluded are precisely those dropped by the differencing.)
\cr\cr Missing values are allowed, and are handled exactly in method `\code{ML}`.
\cr\cr If \code{transform.pars} is \code{TRUE}, the optimisation is done using an alternative parametrization which is a variation on that suggested by Jones (1980) and ensures that the model is stationary. For an AR(p) model the parametrisation is via the inverse tanh of the partial autocorrelations: the same procedure is applied (separately) to the AR and seasonal AR terms. The MA terms are not constrained to be invertible during optimisation, but they will be converted to invertible form after optimisation if \code{transform.pars} is \code{TRUE}.
\cr\cr Conditional sum-of-squares is provided mainly for expositional purposes. This computes the sum of squares of the fitted innovations from observation \code{n.cond} on, (where \code{n.cond} is at least the maximum lag of an AR term), treating all earlier innovations to be zero. Argument \code{n.cond} can be used to allow comparability between different fits. The `part log-likelihood` is the first term, half the log of the estimated mean square. Missing values are allowed, but will cause many of the innovations to be missing.
\cr\cr When regressors are specified, they are orthogonalised prior to fitting unless any of the coefficients is fixed. It can be helpful to roughly scale the regressors to zero mean and unit variance.
}

\examples{
tsarima(airport$Travellers, 
        order = c(1, 1, 0), seasonal = c(0, 1, 1),
        log = TRUE, include.const = TRUE)
}
\references{
Box, G. E. P., & Jenkins, G. M. (1970). Time series analysis: Forecasting and control. Holden-Day.

Hyndman, R. J., & Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}

Hyndman, R. J., Athanasopoulos, G., Bergmeir, C., Caceres, G., Chhay, L., O'Hara-Wild, M., Petropoulos, F., Razbash, S., Wang, E., & Yasmeen, F. (2025). \emph{forecast: Forecasting functions for time series and linear models}. R package version 8.24.0, \cr \url{https://pkg.robjhyndman.com/forecast/}.

Hyndman, R. J., & Khandakar, Y. (2008). Automatic time series forecasting: the forecast package for R. \emph{Journal of Statistical Software}, \strong{27}(3), 1-22. \doi{10.18637/jss.v027.i03}.

Brockwell, P. J., & Davis, R. A. (1996). Introduction to Time Series and Forecasting. Springer, New York. Sections 3.3 and 8.3.

Durbin, J., & Koopman, S. J. (2001). Time Series Analysis by State Space Methods. Oxford University Press.

Gardner, G, Harvey, A. C., & Phillips, G. D. A. (1980). Algorithm AS 154: An algorithm for exact maximum likelihood estimation of autoregressive-moving average models by means of Kalman filtering. \emph{Applied Statistics}, \strong{29}, 311-322. \doi{10.2307/2346910}.

Harvey, A. C. (1993). Time Series Models. 2nd Edition. Harvester Wheatsheaf. Sections 3.3 and 4.4.

Jones, R. H. (1980). Maximum likelihood fitting of ARMA models to time series with missing observations. \emph{Technometrics}, \strong{22}, 389-395. \doi{10.2307/1268324}.

Ripley, B. D. (2002). Time series in R 1.5.0. \emph{R News}, \strong{2}(2), 2-7. \url{https://www.r-project.org/doc/Rnews/Rnews_2002-2.pdf}
}
\seealso{
\link{arima}
}
\author{
Ka Yui Karl Wu
}
