% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_known_mf.R
\name{add_known_mf}
\alias{add_known_mf}
\title{Add metainformation derived from ume::known_mf}
\usage{
add_known_mf(mfd, mf_col = "mf", known_mf = ume::known_mf, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{mf_col}{Name of the column in mfd that has the molecular formula information (default: "mf").
Formulas have upper case element symbols and elements in the formula are ordered according to the Hill system.}

\item{known_mf}{data.table with known molecular formulas (\code{ume::known_mf}).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A data.table containing additional columns having information on formula categories
}
\description{
Join molecular formula data and metadata about known formulas
(e.g. annotate carboxylic-rich alicyclic molecules (CRAM)).
The name of the molecular formula column will be set to "mf".
}
\examples{
add_known_mf(mfd = mf_data_demo)
}
\references{
\strong{CRAM}
Hertkorn N., Benner R., Frommberger M., Schmitt-Kopplin P., Witt M.,
Kaiser K., Kettrup A., Hedges J.I. (2006). Characterization of a major
refractory component of marine dissolved organic matter.
\emph{Geochimica et Cosmochimica Acta}, \strong{70}, 2990-3010.
\doi{10.1016/j.gca.2006.03.021}
\strong{Surfactants}
Lechtenfeld O.J., Koch B.P., Gasparovic B., Frka S., Witt M.,
Kattner G. (2013). The influence of salinity on the molecular and
optical properties of surface microlayers in a karstic estuary.
Marine Chemistry, 150, 25-38.
\doi{10.1016/j.marchem.2013.01.006}

\strong{Ideg}
Flerus R., Lechtenfeld O.J., Koch B.P., McCallister S.L., Schmitt-Kopplin P.,
Benner R., Kaiser K., Kattner G. (2012). A molecular perspective on
the ageing of marine dissolved organic matter. \emph{Biogeosciences}, \strong{9},
1935-1955.
\doi{10.5194/bg-9-1935-2012}

\strong{iTerr}
Medeiros P.M., Seidel M., Niggemann J., Spencer R.G.M., Hernes P.J.,
Yager P.L., Miller W.L., Dittmar T., Hansell D.A. (2016).
A novel molecular approach for tracing terrigenous dissolved organic matter
into the deep ocean. \emph{Global Biogeochemical Cycles}, \strong{30}, 689-699.
\doi{10.1002/2015gb005320}
}
\seealso{
Other Formula assignment: 
\code{\link{calc_eval_params}()},
\code{\link{check_formula_library}()},
\code{\link{eval_isotopes}()},
\code{\link{ume_assign_formulas}()}
}
\author{
Boris P. Koch
}
\concept{Formula assignment}
\keyword{misc}
