% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_data_summary.R
\name{calc_data_summary}
\alias{calc_data_summary}
\title{Create a Data Summary Table for Element Ratios and Parameters}
\usage{
calc_data_summary(mfd, grp = "file_id", ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{grp}{Character vector. Names of columns (e.g., sample or file identifiers)
used to aggregate results.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{data.table} containing the summarized results, with columns including:
\describe{
\item{n(mf)}{Number of molecular formulas per group.}
\item{accuracy (median)}{Median accuracy in parts-per-million (ppm) for the identified peaks.}
\item{accuracy (3 sigma cut-off)}{Maximum ppm accuracy within a three-sigma range.}
\item{wa(mz)}{Weighted average m/z value.}
\item{wa(DBE)}{Weighted average Double Bond Equivalent (DBE).}
\item{wa(element)}{Weighted averages for elements (C, H, N, O, P, S) and ratios (O/C, H/C, N/C, S/C).}
\item{wa(NOSC)}{Weighted average nominal oxidation state of carbon.}
\item{wa(delG0_Cox)}{Weighted average Gibbs free energy (Cox) in kJ/mol.}
\item{wa(AI)}{Weighted average aromaticity index.}
\item{wa(C/N) and wa(C/S)}{Ratios derived from N/C and S/C.}
\item{ideg, ideg_n}{Indices for degree of identification, as calculated by \code{calc_ideg()}.}
\item{iterr, iterr_n, iterr2, iterr2_n}{Iteration error indices from \code{calc_iterr()}.}
\item{median(i_magnitude)}{Median intensity value.}
\item{int(basepeak)}{Intensity of the base peak.}
\item{int(summed)}{Summed intensity of all peaks.}
}
}
\description{
Generates a data summary table that provides intensity-weighted averages for element ratios,
mass accuracy, and additional parameters. Results can be grouped based on the specified grouping columns.
}
\details{
This function computes a variety of weighted averages and summary statistics for mass spectrometry data
using the provided peak list (\code{mfd}). Calculated values include weighted averages for elemental counts
(e.g., Carbon, Hydrogen), elemental ratios (e.g., O/C, H/C), and additional parameters such as the base peak intensity
and summed intensities. It also calculates the aromaticity index (\code{wa(AI)}) based on the elemental composition.
If grouping columns are provided, the summary statistics are calculated for each group.

The function also joins additional indices (\code{ideg}, \code{iterr}) from related functions \code{calc_ideg()} and \code{calc_iterr()}
to the final summary table.
}
\examples{
# Example using demo data, grouping by file ID
calc_data_summary(mfd = mf_data_demo, grp = c("file_id"))
}
\seealso{
Other calculations: 
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
