% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_eval_params.R
\name{calc_eval_params}
\alias{calc_eval_params}
\title{Calculate UME Evaluation Parameters}
\usage{
calc_eval_params(mfd, verbose = FALSE, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
The original \code{data.table} \code{mfd} with additional evaluation columns:
\describe{
\item{\code{nm}}{Nominal molecular mass: Calculated if not already present.}
\item{\code{dbe})}{Double Bond Equivalent (measure of unsaturation).}
\item{\code{kmd}}{Kendrick mass defect for CH4 versus O exchange.}
\item{\code{O/C}, \code{H/C}, \code{N/C}, \code{S/C})}{Element ratios for a molecular formula.}
\item{\code{nsp_type}, \code{snp_check}}{Types of combinations of N, S, and P atoms in a formula.}
\item{\verb{nosc``\}\{Weighted average nominal oxidation state of carbon.\} \\item\{}delG0_Cox\verb{\}\{Weighted average Gibbs free energy (Cox) in kJ/mol.\} \\item\{}ai\verb{\}\{Aromaticity index.\} \\item\{}ppm_filt`}{A mass accuracy threshold calculated for each spectrum.}
}
}
\description{
This function calculates and adds several evaluation parameters as additional columns to the \code{mfd} data table.
These parameters are essential for evaluating the molecular structure and isotopic distribution, enabling further analysis.
For a detailed description of the output table, see \code{help(mf_data_demo)}.
}
\examples{
# Example usage with a demo molecular formula dataset
mfd_with_params <- calc_eval_params(mfd = mf_data_demo, verbose = TRUE)
}
\references{
Hughey C.A., Hendrickson C.L., Rodgers R.P., Marshall A.G., Qian K.N. (2001).
Kendrick mass defect spectrum: A compact visual analysis for ultrahigh-resolution
broadband mass spectra. \emph{Analytical Chemistry}, \strong{73}, 4676-4681.
\doi{10.1021/ac010560w}

Koch B.P., Dittmar T. (2006). From mass to structure:
an aromaticity index for high-resolution mass data of natural organic matter.
\emph{Rapid Communications in Mass Spectrometry}, \strong{20}, 926-932.
\doi{10.1002/rcm.2386}

LaRowe D.E., Van Cappellen P. (2011). Degradation of natural organic matter:
A thermodynamic analysis. \emph{Geochimica et Cosmochimica Acta}, \strong{75}, 2030-2042.
\doi{10.1016/j.gca.2011.01.020}
}
\seealso{
Other Formula assignment: 
\code{\link{add_known_mf}()},
\code{\link{check_formula_library}()},
\code{\link{eval_isotopes}()},
\code{\link{ume_assign_formulas}()}

Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\author{
Boris P. Koch
}
\concept{Formula assignment}
\concept{calculations}
