% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_dbe_vs_ppm.R
\name{uplot_dbe_vs_ppm}
\alias{uplot_dbe_vs_ppm}
\title{Plot DBE vs ppm with Option for Interactive Plot}
\usage{
uplot_dbe_vs_ppm(
  df,
  size_dots = 0.5,
  cex.axis = 1,
  cex.lab = 1.4,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{df}{A data frame containing the data. The columns \code{ppm} (ppm values), \code{dbe} (DBE values),
and \code{file_id} (for coloring the points) should be present in the data.}

\item{size_dots}{Numeric. Size of the dots in the plot (default = 0.5).}

\item{cex.axis}{Numeric. Size of axis text (default is \code{1}).}

\item{cex.lab}{Numeric. Size of axis labels (default is \code{1.4}).}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{ggplot} object or a \code{plotly} object depending on the \code{plotly} argument.
}
\description{
This function generates a scatter plot of DBE (Double Bond Equivalent) versus parts per million (ppm) from the provided data.
It also provides the option to customize the appearance and to return an interactive \code{plotly} plot.
}
