% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_freq_vs_ppm.R
\name{uplot_freq_vs_ppm}
\alias{uplot_freq_vs_ppm}
\title{Mass Accuracy Frequency Histogram}
\usage{
uplot_freq_vs_ppm(
  df,
  col = "grey",
  width = 0.01,
  gg_size = 12,
  logo = TRUE,
  plotly = FALSE
)
}
\arguments{
\item{df}{A \code{data.table} or \code{data.frame} containing columns:
\itemize{
\item \code{ppm} — mass accuracy in ppm
\item \verb{14N}, \verb{32S}, \verb{31P}, \code{dbe_o} — required for consistency with UME QC tools
}}

\item{col}{Character. Histogram bar color. Default \code{"grey"}.}

\item{width}{Numeric. Histogram bin width (not used when \code{bins = 100}).}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}
}
\value{
A \strong{ggplot2 histogram}, or a \strong{plotly object} if \code{plotly = TRUE}.
}
\description{
Creates a histogram showing the frequency distribution of mass accuracy
values (\code{ppm}).
Displays median and quantile statistics in the title and optionally adds
a UME caption (logo).
The plot uses the unified UME theme (\code{theme_uplots()}), ensuring visual
consistency across all \verb{uplot_*} functions.
}
\details{
This plot is useful for visual inspection of mass accuracy performance.
The required additional columns (\verb{14N}, \verb{32S}, \verb{31P}, \code{dbe_o}) ensure that the
dataset is a complete UME molecular formula table and can be compared
to other quality-control plots.
}
\examples{
uplot_freq_vs_ppm(mf_data_demo)

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
