% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_isotope_precision.R
\name{uplot_isotope_precision}
\alias{uplot_isotope_precision}
\title{Precision of Isotope Abundance}
\usage{
uplot_isotope_precision(
  mfd,
  z_var = "nsp_tot",
  int_col = "norm_int",
  size_dots = 1.5,
  bins = 100,
  data_reduction = FALSE,
  tf = FALSE,
  logo = TRUE,
  plotly = FALSE,
  cex.axis = 1,
  cex.lab = 1.4
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{z_var}{Column used for color mapping (default: "nsp_tot")}

\item{int_col}{Intensity column (default: "norm_int")}

\item{size_dots}{Numeric. Size of the dots in the plot (default = 0.5).}

\item{bins}{Number of bins used when data_reduction = TRUE}

\item{data_reduction}{Logical. If TRUE, bins the data and uses bin medians
(recommended for very large datasets; speeds up rendering massively).}

\item{tf}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. Return a plotly object instead of ggplot.}

\item{cex.axis}{Numeric. Size of axis text (default is \code{1}).}

\item{cex.lab}{Numeric. Size of axis labels (default is \code{1.4}).}
}
\value{
A \code{ggplot} or \code{plotly} object.
}
\description{
Visualizes the deviation between measured and theoretical 13C isotope ratios.
Supports optional data reduction (binning) to greatly enhance interactive
rendering speed in Plotly.
}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
