% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator.R
\name{add_indicators}
\alias{add_indicators}
\title{Add indicator values as columns to a data frame}
\usage{
add_indicators(dat, x)
}
\arguments{
\item{dat}{\code{[data.frame]}}

\item{x}{\code{[indicator]} or \code{[indication]} object. See examples.}
}
\value{
\code{dat} with extra columns defined by \code{x} attached.
}
\description{
Compute and add externally defined indicators to data frame.
If necessary, values are recycled over records.
}
\examples{
ii <- indicator(
 hihi = 2*sqrt(height)
 , haha = log10(weight)
 , lulz = mean(height)
 , wo0t = median(weight)
)

# note: mean and median are repeated
add_indicators(women, ii)

# compute indicators first, then add
out <- confront(women, ii)
add_indicators(women, out)

}
\concept{indicators}
