% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_vangogh_cvd.R
\name{get_cvd_safe_palettes}
\alias{get_cvd_safe_palettes}
\title{Get CVD-Safe Van Gogh Palettes}
\usage{
get_cvd_safe_palettes(
  min_distance = 15,
  cvd_types = c("deutan", "protan", "tritan")
)
}
\arguments{
\item{min_distance}{Numeric. Minimum CIELAB distance threshold. Default 15.}

\item{cvd_types}{Character vector. Which CVD types to check. Options:
"deutan", "protan", "tritan". Default checks all.}
}
\value{
Character vector of palette names that meet the criteria
}
\description{
Returns a list of Van Gogh palettes that meet minimum accessibility
standards for color vision deficiency.
}
\examples{
\dontrun{
# Get highly accessible palettes
safe_palettes <- get_cvd_safe_palettes(min_distance = 20)

# Use a safe palette
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point() +
  scale_color_vangogh(safe_palettes[1])
}

}
