% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Reinis}
\alias{Reinis}
\title{Risk Factors for Coronary Heart Disease}
\format{
A 6-dimensional array resulting from cross-tabulating 6 binary variables
for 1841 observations. The variable names and their levels are:

\tabular{rll}{
No \tab Name        \tab Levels (meaning) \cr
1  \tab \code{smoke}   \tab \verb{"y", "n"} (smoking)\cr
2  \tab \code{mental}  \tab \verb{"y", "n"} (strenuous mental work)\cr
3  \tab \code{phys}    \tab \verb{"y", "n"} (strenuous physical work)\cr
4  \tab \code{systol}  \tab \verb{"y", "n"} (systolic blood pressure > 140)\cr
5  \tab \code{protein} \tab \verb{"y", "n"} (ratio of beta to alpha lipoproteins > 3)\cr
6  \tab \code{family}  \tab \verb{"y", "n"} (family history of CHD)\cr
}
}
\source{
Originally from the \pkg{gRbase} package as \code{data(reinis, package = "gRbase")}
}
\description{
Data from the beginning of a 15-year follow-up study of probable risk factors
for coronary thrombosis. The data are from 1841 men employed in a Czechoslovakian
car factory and represent all possible combinations of the six risk factors.
}
\details{
The study was conducted to examine risk factors for coronary heart disease (CHD) and
collected information on smoking habits, mental and physical work strain, systolic
blood pressure, ratio of lipoproteins, and family history of CHD.

The six variables form a \eqn{2^6 = 64} contingency table. The data have been used
extensively to illustrate model search procedures for high-dimensional contingency tables.
}
\examples{
data(Reinis)
str(Reinis)
ftable(Reinis, row.vars = 1:3)

# Fit all 0-way through 6-way models using Kway()
Reinis.gmodels <- Kway(Freq ~ smoke + mental + phys + systol + protein + family,
                       data = Reinis, family = poisson)

# Examine fit statistics
LRstats(Reinis.gmodels)

# Sequential tests for k vs k+1 way effects
anova(Reinis.gmodels, test = "Chisq")

# Fit sequential models of joint independence
Reinis.seqjoint <- seq_loglm(Reinis, type = "joint", prefix="joint")
LRstats(Reinis.seqjoint)

# Fit sequential models of conditional independence
Reinis.seqcond <- seq_loglm(Reinis, type = "conditional", prefix = "cond")
LRstats(Reinis.seqcond)

}
\references{
Edwards, D. and Havranek, T. (1985).
A fast procedure for model search in multidimensional contingency tables.
\emph{Biometrika}, 72, 339-351.

Gauraha, N. and Parui, S. K. (2020).
Mutual conditional independence and its applications to model selection in Markov networks.
\emph{Annals of Mathematics and Artificial Intelligence}, 88, 951-972.
\doi{10.1007/s10472-020-09690-7}

Reinis, Z., Pokorny, J., Basika, V., Tiserova, J., Gorican, K., Horakova, D.,
Stuchlikova, E., Havranek, T., and Hrabovsky, F. (1981).
Prognostic significance of the risk profile in the prevention of coronary heart disease.
\emph{Bratis. lek. Listy}, 76, 137-150.
}
\keyword{datasets}
