% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_points_2d.R
\name{critical_points_2d}
\alias{critical_points_2d}
\title{Critical points of a two-variable function using gradient and Hessian}
\usage{
critical_points_2d(
  f,
  xlim,
  ylim,
  start_n = c(7L, 7L),
  n_rand = 40L,
  h = NULL,
  tol_grad = 1e-06,
  tol_merge = 0.001,
  tol_eig = 1e-06,
  maxit = 200,
  optim_method = c("BFGS", "Nelder-Mead"),
  plot = TRUE,
  grid_plot = c(60L, 60L),
  surface_colorscale = "YlGnBu",
  surface_opacity = 0.85,
  cp_colors = list(minimum = "#2ca02c", maximum = "#d62728", saddle = "#1f77b4", flat =
    "#ff7f0e"),
  cp_size = 6,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "f(x,y)"))
)
}
\arguments{
\item{f}{Function of two variables \code{f(x, y)} returning a numeric scalar.}

\item{xlim}{Numeric vector \code{c(xmin, xmax)} defining the domain in the
x-direction.}

\item{ylim}{Numeric vector \code{c(ymin, ymax)} defining the domain in the
y-direction.}

\item{start_n}{Integer vector of length two. Number of regular starting
points per axis for the grid.}

\item{n_rand}{Integer. Number of additional random starting points inside
the domain.}

\item{h}{Numeric step size for finite-difference gradients and Hessians.
If \code{NULL}, an automatic step size is used.}

\item{tol_grad}{Numeric tolerance. Points with gradient norm below this
threshold are treated as stationary.}

\item{tol_merge}{Numeric tolerance for merging nearby solutions.}

\item{tol_eig}{Numeric tolerance used when classifying eigenvalues of the
Hessian.}

\item{maxit}{Maximum number of iterations permitted for numerical
optimization.}

\item{optim_method}{Character string naming an optimization method supported
by \code{stats::optim}, such as \code{"BFGS"} or \code{"Nelder-Mead"}.}

\item{plot}{Logical. If \code{TRUE}, a \pkg{plotly} surface with critical
points is drawn.}

\item{grid_plot}{Integer vector of length two. Resolution of the grid used
when drawing the surface.}

\item{surface_colorscale}{Character. Name of the Plotly colorscale for the
surface.}

\item{surface_opacity}{Numeric between 0 and 1 giving the opacity of the
surface.}

\item{cp_colors}{Named list mapping each critical point type to a color.
Expected names: \code{"minimum"}, \code{"maximum"}, \code{"saddle"},
\code{"flat"}.}

\item{cp_size}{Numeric. Size of the point markers.}

\item{scene}{List of Plotly scene options (axis titles, aspect mode, and so
on).}
}
\value{
A list with:
\describe{
\item{\code{critical_points}}{
A data frame with columns \code{x}, \code{y}, \code{z}, the gradient
norm, and the classification label.
}
\item{\code{fig}}{
A \pkg{plotly} object if \code{plot = TRUE}, or \code{NULL} otherwise.
}
}
}
\description{
Identifies stationary points of a function of two variables over a given
rectangular domain. A set of initial points is generated on a regular grid
together with additional random starting points. Each start is refined using
numerical optimization applied to the squared gradient norm. Points with a
sufficiently small gradient norm are kept and then merged if they are too
close to each other.
}
\details{
Each surviving point is classified based on the eigenvalues of the numerical
Hessian matrix. The Hessian classification uses four categories:
\itemize{
\item \code{"minimum"}  - both eigenvalues positive,
\item \code{"maximum"}  - both eigenvalues negative,
\item \code{"saddle"}   - mixed signs,
\item \code{"flat"}     - small eigenvalues, inconclusive classification.
}

Optionally, a 3D surface with the detected critical points can be displayed
using \pkg{plotly}.
}
\examples{
\donttest{
f <- function(x, y) x^2 + y^2
critical_points_2d(f, xlim = c(-2, 2), ylim = c(-2, 2), plot = FALSE)
}

}
