% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_network_analysis.R
\name{wbt_extract_streams}
\alias{wbt_extract_streams}
\title{Extract streams}
\usage{
wbt_extract_streams(
  flow_accum,
  output,
  threshold,
  zero_background = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{flow_accum}{Input raster D8 flow accumulation file.}

\item{output}{Output raster file.}

\item{threshold}{Threshold in flow accumulation values for channelization.}

\item{zero_background}{Flag indicating whether a background value of zero should be used.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Extracts stream grid cells from a flow accumulation raster.
}
\keyword{StreamNetworkAnalysis}
