% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_segmentation}
\alias{wbt_lidar_segmentation}
\title{Lidar segmentation}
\usage{
wbt_lidar_segmentation(
  input,
  output,
  radius = 2,
  num_iter = 50,
  num_samples = 10,
  threshold = 0.15,
  model_size = 15,
  max_slope = 80,
  norm_diff = 10,
  maxzdiff = 1,
  classes = FALSE,
  ground = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output LiDAR file.}

\item{radius}{Search Radius.}

\item{num_iter}{Number of iterations.}

\item{num_samples}{Number of sample points on which to build the model.}

\item{threshold}{Threshold used to determine inlier points.}

\item{model_size}{Acceptable model size.}

\item{max_slope}{Maximum planar slope.}

\item{norm_diff}{Maximum difference in normal vectors, in degrees.}

\item{maxzdiff}{Maximum difference in elevation (z units) between neighbouring points of the same segment.}

\item{classes}{Segments don't cross class boundaries.}

\item{ground}{Classify the largest segment as ground points?.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Segments a LiDAR point cloud based on differences in the orientation of fitted planar surfaces and point proximity.
}
\keyword{LiDARTools}
