% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sumtrndseason.R
\name{show_sumtrndseason}
\alias{show_sumtrndseason}
\title{Plot seasonal rates of change based on average estimates for multiple window widths}
\usage{
show_sumtrndseason(
  mod,
  doystr = 1,
  doyend = 364,
  yromit = NULL,
  justify = c("center", "left", "right"),
  win = 5:15,
  txtsz = 6,
  cols = c("lightblue", "lightgreen"),
  base_size = 11
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{yromit}{optional numeric vector for years to omit from the plot, see details}

\item{justify}{chr string indicating the justification for the trend window}

\item{win}{numeric vector indicating number of years to use for the trend window}

\item{txtsz}{numeric for size of text labels inside the plot}

\item{cols}{vector of low/high colors for trends}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}
}
\value{
A \code{\link[ggplot2]{ggplot2}} plot
}
\description{
Plot seasonal rates of change based on average estimates for multiple window widths
}
\details{
This function plots output from \code{\link{anlz_sumtrndseason}}.

The optional \code{yromit} vector can be used to omit years from the plot and trend assessment. This may be preferred if seasonal estimates for a given year have very wide confidence intervals likely due to limited data, which can skew the trend assessments.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
show_sumtrndseason(mod, doystr = 90, doyend = 180, justify = 'center', win = 2:3)
}
\seealso{
Other show: 
\code{\link{show_sumtrndseason2}()}
}
\concept{show}
