% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpsSpectrum.R
\name{lpsSpectrum}
\alias{lpsSpectrum}
\title{lpsSpectrum}
\usage{
lpsSpectrum(
  listOfFiles = NULL,
  optLogFilePath = NULL,
  beginTime = 0,
  centerTime = FALSE,
  endTime = 0,
  resolution = 40,
  fftLength = 0,
  windowSize = 20,
  windowShift = 5,
  window = "BLACKMAN",
  order = 0,
  preemphasis = -0.95,
  deemphasize = TRUE,
  toFile = TRUE,
  explicitExt = NULL,
  outputDirectory = NULL,
  forceToLog = useWrasspLogger,
  verbose = TRUE
)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds
(default: begin of data)}

\item{centerTime}{= <time>: set single-frame analysis with the analysis
window centred at <time> seconds; overrules beginTime, endTime and
windowShift options}

\item{endTime}{= <time>: set end of analysis interval to <time> seconds
(default: end of data)}

\item{resolution}{= <freq>: set FFT length to the smallest value which
results in a frequency resolution of <freq> Hz or better (default: 40.0)}

\item{fftLength}{= <num>: set FFT length to <num> points (overrules default
and 'resolution' option)}

\item{windowSize}{= <dur>: set effective analysis window size to <dur> ms}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms
(default: 5.0)}

\item{window}{= <type>: set analysis window function to <type> (default:
BLACKMAN)}

\item{order}{= <num>: set prediction order to <num> (default: sampling
rate in kHz + 3)}

\item{preemphasis}{= <val>: set pre-emphasis factor to <val> (default:
-0.95)}

\item{deemphasize}{(default: undo spectral tilt due to
pre-emphasis used in LP analysis, i.e. TRUE)}

\item{toFile}{write results to file (default extension depends on )}

\item{explicitExt}{set if you wish to override the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return
AsspDataObj of that file
}
\description{
Calculate Linear Prediction smoothed spectrum using libassp
}
\details{
Short-term spectral analysis of the signal in <listOfFiles>
using the Fast Fourier Transform and linear predictive smoothing.
Analysis results will be written to a file with the
base name of the input file and the spectrum type in
lower case as extension (i.e. '.lps').
Default output is in SSFF format with the
spectrum type in lower case as track name.
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# calculate lps spectrum
res <- lpsSpectrum(path2wav, toFile=FALSE)

# plot spectral values at midpoint of signal
plot(res$lps[dim(res$lps)[1]/2,], 
     type='l', 
     xlab='spectral value index', 
     ylab='spectral value')

}
\seealso{
\code{\link{dftSpectrum}}, \code{\link{cssSpectrum}}, \code{\link{cepstrum}}; 
all derived from libassp's spectrum function.
}
\author{
Raphael Winkelmann

Lasse Bombien
}
