# Extracted from test-CFI.R:278

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("ranger")
skip_if_not_installed("mlr3learners")
skip_if_not_installed("knockoff")
set.seed(123)
task = sim_dgp_correlated(n = 500, r = 0.7)
learner = lrn("regr.ranger", num.trees = 100)
measure = msr("regr.mse")
resampling = rsmp("cv", folds = 5)
gaussian_sampler = KnockoffGaussianSampler$new(task)
cfi = CFI$new(
		task = task,
		learner = learner,
		measure = measure,
		resampling = resampling,
		sampler = gaussian_sampler
	)
expect_contains(cfi$.__enclos_env__$private$.ci_methods, "cpi")
cfi$compute()
